set more off
global path_in ""
global path_temp ""
global path_out ""

* Store within-industry predictions from Table 12

**1. Preparing data
use $path_in\KLEMS_b2008_clean, clear
	drop if code=="TOT" /*keep sector-specific data*/
	
	*Set productivity measure as country leave-out TFP
	local LP D1_lnTFPva_oth
		
	*Enforce productivity measure
	rename `LP' D1_LP1_EMP
	drop if D1_LP1_EMP==.

	egen ct=group(country year)
	egen ic=group(code country)
	egen it=group(code year)

	gen decade=1970 if year<=1980
	replace decade=8000 if year>1980
save $path_temp\temp1, replace


**2. Estimate Table 12, store estimates, calculate predictions
use $path_temp\temp1, clear
	
	tsset cross year
	
	local ownd1 	"D1_LP1_EMP L.D1_LP1_EMP L2.D1_LP1_EMP"
	local dec1		"decade==1970"
	local ownd2 	"D1_LP1_EMP L.D1_LP1_EMP L2.D1_LP1_EMP L3.D1_LP1_EMP L4.D1_LP1_EMP L5.D1_LP1_EMP"
	local dec2		"decade==8000"
	local aggR		"D1_lnVA_QI_LO L.D1_lnVA_QI_LO L2.D1_lnVA_QI_LO L3.D1_lnVA_QI_LO L4.D1_lnVA_QI_LO L5.D1_lnVA_QI_LO"
	local aggN		"D1_lnVA_LO L.D1_lnVA_LO L2.D1_lnVA_LO L3.D1_lnVA_LO L4.D1_lnVA_LO L5.D1_lnVA_LO"
	
	*Set FE
	local controls 	"i.sectorgroup i.country*i.bcycle i.country*year i.year"	
	
	foreach var in E H HW Yn Yr LS {
		gen b`var'_own=.
	}
	
	*Estimate industry-level impacts		
	*Estimate Table 12, emp
	xi:reg D1_lnEMP `ownd1' `controls' [w=weight_c] if `dec1', clus(ic) 
			lincom D1_LP1_EMP + L.D1_LP1_EMP + L2.D1_LP1_EMP
				replace bE_own =r(estimate) if `dec1'
	xi:reg D1_lnEMP `ownd2' `controls' [w=weight_c] if `dec2', clus(ic) 
			lincom D1_LP1_EMP + L.D1_LP1_EMP + L2.D1_LP1_EMP + L3.D1_LP1_EMP + L4.D1_LP1_EMP + L5.D1_LP1_EMP
				replace bE_own =r(estimate) if `dec2'
				
	*Estimate Table 12, hrs
	xi:reg D1_lnH_EMP `ownd1' `controls' [w=weight_h_c] if `dec1', clus(ic)
			lincom D1_LP1_EMP + L.D1_LP1_EMP + L2.D1_LP1_EMP
				replace bH_own =r(estimate) if `dec1'
	xi:reg D1_lnH_EMP `ownd2' `controls' [w=weight_h_c] if `dec2', clus(ic) 
			lincom D1_LP1_EMP + L.D1_LP1_EMP + L2.D1_LP1_EMP + L3.D1_LP1_EMP + L4.D1_LP1_EMP + L5.D1_LP1_EMP
				replace bH_own =r(estimate) if `dec2'
				
	*Estimate Table 12, wagebill
	xi:reg D1_lnLAB `ownd1' `controls' [w=weight_h_c] if `dec1', clus(ic)	
			lincom D1_LP1_EMP + L.D1_LP1_EMP + L2.D1_LP1_EMP
				replace bHW_own =r(estimate) if `dec1'
	xi:reg D1_lnLAB `ownd2' `controls' [w=weight_h_c] if `dec2', clus(ic)	
			lincom D1_LP1_EMP + L.D1_LP1_EMP + L2.D1_LP1_EMP + L3.D1_LP1_EMP + L4.D1_LP1_EMP + L5.D1_LP1_EMP
				replace bHW_own =r(estimate) if `dec2'
				
	*Estimate Table 12, nominal value added
	xi:reg D1_lnVA `ownd1' `controls'  [w=weight_VA_c] if `dec1', clus(ic)	
			lincom D1_LP1_EMP + L.D1_LP1_EMP + L2.D1_LP1_EMP
				replace bYn_own =r(estimate) if `dec1'
	xi:reg D1_lnVA `ownd2' `controls'  [w=weight_VA_c] if `dec2', clus(ic)	
			lincom D1_LP1_EMP + L.D1_LP1_EMP + L2.D1_LP1_EMP + L3.D1_LP1_EMP + L4.D1_LP1_EMP + L5.D1_LP1_EMP
				replace bYn_own =r(estimate) if `dec2'
			
	*Estimate Table 12, real value added
	xi:reg D1_lnVA_QI `ownd1' `controls'  [w=weight_VA_c] if `dec1', clus(ic)	
			lincom D1_LP1_EMP + L.D1_LP1_EMP + L2.D1_LP1_EMP
				replace bYr_own =r(estimate) if `dec1'
	xi:reg D1_lnVA_QI `ownd2' `controls'  [w=weight_VA_c] if `dec2', clus(ic)	
			lincom D1_LP1_EMP + L.D1_LP1_EMP + L2.D1_LP1_EMP + L3.D1_LP1_EMP + L4.D1_LP1_EMP + L5.D1_LP1_EMP
				replace bYr_own =r(estimate) if `dec2'
			
	*Estimate Table 12, laborshare
	xi:reg D1_lnlaborshare `ownd1' `controls'  [w=weight_VA_c] if `dec1', clus(ic)	
			lincom D1_LP1_EMP + L.D1_LP1_EMP + L2.D1_LP1_EMP
				replace bLS_own =r(estimate) if `dec1'
	xi:reg D1_lnlaborshare `ownd2' `controls'  [w=weight_VA_c] if `dec2', clus(ic)	
			lincom D1_LP1_EMP + L.D1_LP1_EMP + L2.D1_LP1_EMP + L3.D1_LP1_EMP + L4.D1_LP1_EMP + L5.D1_LP1_EMP
				replace bLS_own =r(estimate) if `dec2'
	
*Estimate aggregate output impacts
	local controls "i.sectorgroup"

	*Employment
	xi:reg D1_lnEMP `aggR' `controls' [w=weight_c], clus(ic) 
			lincom D1_lnVA_QI_LO + L.D1_lnVA_QI_LO + L2.D1_lnVA_QI_LO + L3.D1_lnVA_QI_LO + L4.D1_lnVA_QI_LO + L5.D1_lnVA_QI_LO
				gen bE_agg =r(estimate)
	
	*Hrs
	xi:reg D1_lnH_EMP `aggR'  `controls' [w=weight_h_c], clus(ic)
			lincom D1_lnVA_QI_LO + L.D1_lnVA_QI_LO + L2.D1_lnVA_QI_LO + L3.D1_lnVA_QI_LO + L4.D1_lnVA_QI_LO + L5.D1_lnVA_QI_LO
				gen bH_agg =r(estimate)
				
	*Wagebill
	xi:reg D1_lnLAB `aggN' `controls' [w=weight_h_c], clus(ic) 
			lincom D1_lnVA_LO + L.D1_lnVA_LO + L2.D1_lnVA_LO + L3.D1_lnVA_LO + L4.D1_lnVA_LO + L5.D1_lnVA_LO
				gen bHW_agg =r(estimate)
		
	*Nominal value added
	xi:reg D1_lnVA `aggN' `controls' [w=weight_VA_c], clus(ic)
			lincom D1_lnVA_LO + L.D1_lnVA_LO + L2.D1_lnVA_LO + L3.D1_lnVA_LO + L4.D1_lnVA_LO + L5.D1_lnVA_LO
				gen bYn_agg =r(estimate)
	
	*Real value added
	xi:reg D1_lnVA_QI `aggR' `controls' [w=weight_VA_c], clus(ic)
			lincom D1_lnVA_QI_LO + L.D1_lnVA_QI_LO + L2.D1_lnVA_QI_LO + L3.D1_lnVA_QI_LO + L4.D1_lnVA_QI_LO + L5.D1_lnVA_QI_LO
				gen bYr_agg =r(estimate)

	*Laborshare
	xi:reg D1_lnlaborshare `aggN' `controls' [w=weight_VA_c], clus(ic)
			lincom D1_lnVA_LO + L.D1_lnVA_LO + L2.D1_lnVA_LO + L3.D1_lnVA_LO + L4.D1_lnVA_LO + L5.D1_lnVA_LO
				gen bLS_agg =r(estimate)
				
		*Calculate time-averaged share of each industry's nominal value added in national income
		gen temp=VA/VA_TOT
		bysort country code: egen VAshare=mean(temp)
		bysort country year: egen test=sum(VAshare)	/*note: not 1 since we exclude some industries, together making up around 10% of total VA*/
		drop temp test 

	keep country code code_hier decade sectorgroup year weight* b*_own* b*_agg* VAshare D1_LP1_EMP D1_lnVA_QI_TOT D1_lnVA_P_TOT
save $path_temp\temp2, replace


*Predicting own, supplier, customer effects for all outcomes, aggregating across industries
	foreach var in E H HW LS Yr Yn {
	use $path_temp\temp2, clear

		*Own effect
		gen D`var'_own = 	b`var'_own * D1_LP1_EMP
		label var D`var'_own "Country-industry-year `var' change (in log points) from productivity growth in own industry"
			bysort country year (D`var'_own) : gen allmissing_own = mi(D`var'_own[1])

		*Spillover effect from up- & downstream -- not included here, so set to zero
		gen D`var'_sup = 	0
		gen D`var'_cus= 	0
		label var D`var'_sup "Country-industry-year `var' change (in log points) from productivity growth in supplier industries"	
		label var D`var'_cus "Country-industry-year `var' change (in log points) from productivity growth in customer industries"	
			bysort country year (D`var'_sup) : gen allmissing_sup = mi(D`var'_sup[1])
			bysort country year (D`var'_cus) : gen allmissing_cus = mi(D`var'_cus[1])

		save $path_temp\temp_`var', replace
	}

*Predicting industry-level output effects (own, supplier, customer) 
	foreach var in Yr Yn {
	use $path_temp\temp2, clear

		*Own effect
		gen D`var'_own = 	b`var'_own * D1_LP1_EMP
		label var D`var'_own "Country-industry-year `var' change (in log points) from productivity growth in own industry"
			bysort country year (D`var'_own) : gen allmissing_own = mi(D`var'_own[1])

		*Spillover effect from up- & downstream -- not included here, so set to zero
		gen D`var'_sup = 	0
		gen D`var'_cus= 	0
		label var D`var'_sup "Country-industry-year `var' change (in log points) from productivity growth in supplier industries"	
		label var D`var'_cus "Country-industry-year `var' change (in log points) from productivity growth in customer industries"	
			bysort country year (D`var'_sup) : gen allmissing_sup = mi(D`var'_sup[1])
			bysort country year (D`var'_cus) : gen allmissing_cus = mi(D`var'_cus[1])

		keep country code code_hier year D`var'_own D`var'_sup D`var'_cus b*_agg* VAshare 
		
		foreach i in own sup cus {
			gen D1_lnVAict_hat_`i' = D`var'_`i'  * VAshare
			bysort country year: egen D1_lnVAct_hat_`i'_LO  = sum(D1_lnVAict_hat_`i') if D1_lnVAict_hat_`i'!=.
		}
		keep country code code_hier year D1_lnVAct_hat_own_LO D1_lnVAct_hat_sup_LO D1_lnVAct_hat_cus_LO
		drop if D1_lnVAct_hat_cus_LO==.
		duplicates drop country year, force
		drop code
		
		save $path_temp\temp_ind_`var', replace
	}
	
*Predicting final demand  effects (from own, supplier, customer) for emp, hrs, real output
	foreach var in E H Yr {
	use $path_temp\temp2, clear

	merge m:1 country year using $path_temp\temp_ind_Yr
	keep if _==3
	drop _
	
	gen D`var'_ownagg = D1_lnVAct_hat_own_LO * b`var'_agg
	gen D`var'_supagg = 0
	gen D`var'_cusagg = 0

	save $path_temp\temp_fd_`var', replace
	}		
			
*Predicting final demand  effects (from own, supplier, customer) for wagebill, nominal output
	foreach var in HW Yn LS {
	use $path_temp\temp2, clear

	merge m:1 country year using $path_temp\temp_ind_Yn
	keep if _==3
	drop _
	
	gen D`var'_ownagg = D1_lnVAct_hat_own_LO * b`var'_agg
	gen D`var'_supagg = 0
	gen D`var'_cusagg = 0

	save $path_temp\temp_fd_`var', replace
	}
			
	use $path_temp\temp_E, clear
	merge 1:1 country code year using $path_temp\temp_fd_E
		drop _
	merge 1:1 country code year using $path_temp\temp_H 
		drop _
	merge 1:1 country code year using $path_temp\temp_fd_H
		drop _
	merge 1:1 country code year using $path_temp\temp_HW
		drop _
	merge 1:1 country code year using $path_temp\temp_fd_HW
		drop _
	merge 1:1 country code year using $path_temp\temp_Yn 
		drop _
	merge 1:1 country code year using $path_temp\temp_fd_Yn
		drop _		
	merge 1:1 country code year using $path_temp\temp_Yr 
		drop _
	merge 1:1 country code year using $path_temp\temp_fd_Yr
		drop _		
	merge 1:1 country code year using $path_temp\temp_LS
		drop _	
	merge 1:1 country code year using $path_temp\temp_fd_LS
		drop _	
	keep country code code_hier sector year DE* DH* DY* DLS* weight*
	
	
	foreach var in E H HW Yn Yr LS {
		gen D`var'_agg = D`var'_ownagg + D`var'_cusagg + D`var'_supagg 
			label var D`var'_agg "Country-industry-year `var' change (in log points) from final demand"
		gen D`var'_net = D`var'_own + D`var'_cus + D`var'_sup + D`var'_agg
			label var D`var'_net "Country-industry-year net `var' change (in log points)"
	}	
	
drop *ownagg *supagg *cusagg
cap drop decade

	gen decade=1970 if year<=1980
	replace decade=1980 if year>1980&year<=1990
	replace decade=1990 if year>1990&year<=2000
	replace decade=2000 if year>2000
	
keep  country code code_hier sector year decade DLS_net DYn_net weight*
order country code code_hier sector year decade DLS_net DYn_net
	
save $path_out\Table12_predictions_within, replace	
	
*erase temporary files
	cap erase $path_temp\temp_TFPwide.dta
	cap erase $path_temp\temp1.dta
	cap erase $path_temp\temp2.dta
	foreach var in E H HW LS Yr Yn {
		cap erase $path_temp\temp_`var'.dta
		cap erase $path_temp\temp_fd_`var'.dta
		cap erase $path_temp\temp_ind_`var'.dta
	}
